<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

use function PHPUnit\Framework\isEmpty;

class Login implements FilterInterface
{
    /**
     * Do whatever processing this filter needs to do.
     * By default it should not return anything during
     * normal execution. However, when an abnormal state
     * is found, it should return an instance of
     * CodeIgniter\HTTP\Response. If it does, script
     * execution will end and that Response will be
     * sent back to the client, allowing for error pages,
     * redirects, etc.
     *
     * @param RequestInterface $request
     * @param array|null       $arguments
     *
     * @return RequestInterface|ResponseInterface|string|void
     */
    public function before(RequestInterface $request, $arguments = null)
    {
        if(! auth()->loggedIn()){
            return redirect()->to("login")
                ->with("message","Please login first");
        }

//dd($request);
        //path -> string (14) "recipes/1/edit"
        //null !== expression
        $path = trim(strval(null !== $request->getPath() ? $request->getPath() : '')); // ->path;
        if('' !== $path){
                    //dd($path);
            $path = str_replace('\\','/',$path);
            $exp = explode('/',$path);
            if(is_array($exp)){
                $controller = $exp[0];
            }else{
                $controller = $exp;
            }
            if(! auth()->user()->can_access_by_controller($controller)) {
                return redirect()->to("/")
                    ->with("message","<span style='color:crimson; font-weight:bold;'>You are not authorised to access that section.</span>");
            }
        }
    }

    /**
     * Allows After filters to inspect and modify the response
     * object as needed. This method does not allow any way
     * to stop execution of other after filters, short of
     * throwing an Exception or Error.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param array|null        $arguments
     *
     * @return ResponseInterface|void
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        //
    }
}
