<?php

namespace App\Controllers;

use App\Models\SuppliersModel;
use App\Entities\Supplier;
use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Database\Exceptions\DatabaseException;

class Suppliers extends BaseController
{
    private SuppliersModel $model;

    public function __construct()
    {
        $this->model = new SuppliersModel;
    }
    
    public function index(): string
    {
        
        $data = $this->model
        ->select(("suppliers.*, users.username"))
        ->join("users","users.id = suppliers.users_id","left")
        ->orderBy('Supplier','asc')->findAll();

        return view("Suppliers/index",[
                "suppliers" => $data
            ]);
    }
 
    public function show($id)
    {

        $supplier = $this->getSupplierOr404($id);
        
		$sql = "SELECT inputs.InputID, inputs.InputName FROM inputs WHERE inputs.SupplierID=$id";
		$db = db_connect();
		$inputs = $db->query($sql)->getResult('App\Entities\Input');

        return view("Suppliers/show",[
            "supplier" => $supplier,
            "inputs" => $inputs
        ]);

    }

    public function new()
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1)) );
		}

        return view("Suppliers/new",[
            "supplier" => new Supplier
        ]);
    }

    public function create()
    {

        $supplier = new Supplier($this->request->getPost());

        $id = $this->model->insert($supplier);

        if($id === false){

            return redirect()->back()->with("errors", $this->model->errors())->withInput();

        }

        return redirect()->to("suppliers/$id")->with("message","Supplier saved.");

    }

    public function edit($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $supplier = $this->getSupplierOr404($id);

        return view("Suppliers/edit",[
            "supplier" => $supplier
        ]);

    }


    public function update($id)
    {

        $supplier = $this->getSupplierOr404($id);

        $supplier->fill($this->request->getPost());

        $supplier->__unset("_method");

        if(!$supplier->hasChanged()){
            return redirect()->back()->with("message","Nothing to update.");
        }

        if($this->model->save($supplier)){
            return redirect()->to("suppliers/$id")->with("message","Supplier updated");
        }

        return redirect()->back()->with("errors",$this->model->errors())->withInput();
    }

    public function confirmDelete($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $supplier = $this->getSupplierOr404($id);

        return view("Suppliers/delete",[
            "supplier"=>$supplier
        ]);
    }
    public function delete($id)
    {
        try{
            $this->model->delete($id);

        } catch (DatabaseException $e) {
            return redirect()->back()->with("errors",$this->model->errors())->withInput();
        }
        return redirect()->to("suppliers")->with("message","Supplier deleted.");
    }

    private function getSupplierOr404($id): Supplier
    {
        $supplier = $this->model->find($id);

        if($supplier === null){
            throw new PageNotFoundException("Supplier with id $id not found");
        }

        return $supplier;
    }
}
