<?php

namespace App\Controllers;

use App\Models\RoastLevelsModel;
use App\Entities\RoastLevel;
use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Database\Exceptions\DatabaseException;

class Roastlevels extends BaseController
{
    private RoastLevelsModel $model;

    public function __construct()
    {
        $this->model = new RoastLevelsModel;
    }
    
    public function index(): string
    {
        
        $data = $this->model
        ->select(("roastlevels.*, users.username"))
        ->join("users","users.id = roastlevels.users_id","left")
        ->orderBy('RoastLevel','asc')->findAll();

        return view("Roastlevels/index",[
                "roastlevels" => $data
            ]);
    }
 
    public function show($id)
    {

        $data = $this->getRoastLevelOr404($id);
        
		$sql = "SELECT recipes.RecipeID, recipes.RecipeName FROM recipes WHERE recipes.RoastLevelID=$id";
		$db = db_connect();
		$recipes = $db->query($sql)->getResult('App\Entities\Input');

        return view("Roastlevels/show",[
            "roastlevel" => $data,
            "recipes" => $recipes
        ]);

    }

    public function new()
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1)) );
		}

        return view("Roastlevels/new",[
            "roastlevel" => new RoastLevel
        ]);
    }

    public function create()
    {

        $roastlevel = new RoastLevel($this->request->getPost());

        $id = $this->model->insert($roastlevel);

        if($id === false){

            return redirect()->back()->with("errors", $this->model->errors())->withInput();

        }

        return redirect()->to("roastlevels/$id")->with("message","Roast level saved.");

    }

    public function edit($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $roastlevel = $this->getRoastLevelOr404($id);

        return view("Roastlevels/edit",[
            "roastlevel" => $roastlevel
        ]);

    }


    public function update($id)
    {

        $roastlevel = $this->getRoastLevelOr404($id);

        $roastlevel->fill($this->request->getPost());

        $roastlevel->__unset("_method");

        if(!$roastlevel->hasChanged()){
            return redirect()->back()->with("message","Nothing to update.");
        }

        if($this->model->save($roastlevel)){
            return redirect()->to("roastlevels/$id")->with("message","Roast level updated");
        }

        return redirect()->back()->with("errors",$this->model->errors())->withInput();
    }

    public function confirmDelete($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $roastlevel = $this->getRoastLevelOr404($id);

        return view("Roastlevels/delete",[
            "roastlevel"=>$roastlevel
        ]);
    }
    public function delete($id)
    {
        try{
            $this->model->delete($id);

        } catch (DatabaseException $e) {
            return redirect()->back()->with("errors",$this->model->errors())->withInput();
        }
        return redirect()->to("roastlevels")->with("message","Roast level deleted.");
    }

    private function getRoastLevelOr404($id): RoastLevel
    {
        $roastlevel = $this->model->find($id);

        if($roastlevel === null){
            throw new PageNotFoundException("Roast level with id $id not found");
        }

        return $roastlevel;
    }
}
