<?php

namespace App\Controllers;

use App\Models\RoastColoursModel;
use App\Entities\RoastColour;

use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Database\Exceptions\DatabaseException;

class RoastColours extends BaseController
{
    private RoastColoursModel $model;

    public function __construct()
    {
        $this->model = new RoastColoursModel;
    }

    public function index(): string
    {

        $data = $this->model
            ->select(("roastcolours.*, users.username"))
            ->join("users", "users.id = roastcolours.users_id","left")
            ->findAll();

        return view("RoastColours/index", [
            "roastcolours" => $data
        ]);
    }

    public function show($id)
    {

        $roastcolour = $this->getRoastColourOr404($id);

        $sql = "SELECT recipes.RecipeID, recipes.RecipeName FROM recipes WHERE recipes.RoastColourID=$id";
        $db = db_connect();
        $recipes = $db->query($sql)->getResult('App\Entities\Recipe');

        return view("RoastColours/show", [
            "roastcolour" => $roastcolour,
            "recipes" => $recipes,
        ]);
    }

    public function new()
    {
        if (! auth()->user()->can_edit_by_controller(substr(strrchr(__CLASS__, '\\'), 1))) {
            return redirect()->to(strtolower(substr(strrchr(__CLASS__, '\\'), 1)));
        }

        return view("RoastColours/new", [
            "roastcolour" => new RoastColour
        ]);
    }

    public function create()
    {

        $roastcolour = new RoastColour($this->request->getPost());

        $id = $this->model->insert($roastcolour);

        if ($id === false) {

            return redirect()->back()->with("errors", $this->model->errors())->withInput();
        }

        return redirect()->to("RoastColours/$id")->with("message", "Roast Colour saved.");
    }

    public function edit($id)
    {

        if (! auth()->user()->can_edit_by_controller(substr(strrchr(__CLASS__, '\\'), 1))) {
            return redirect()->to(strtolower(substr(strrchr(__CLASS__, '\\'), 1)) . "/$id");
        }

        $roastcolour = $this->getRoastColourOr404($id);

        return view("RoastColours/edit", [
            "roastcolour" => $roastcolour
        ]);
    }


    public function update($id)
    {

        $roastcolour = $this->getRoastColourOr404($id);

        $roastcolour->fill($this->request->getPost());

        $roastcolour->__unset("_method");

        if (!$roastcolour->hasChanged()) {
            return redirect()->back()->with("message", "Nothing to update.");
        }

        if ($this->model->save($roastcolour)) {
            return redirect()->to("RoastColours/$id")->with("message", "Roast Colour updated");
        }

        return redirect()->back()->with("errors", $this->model->errors())->withInput();
    }

    public function confirmDelete($id)
    {
        if (! auth()->user()->can_edit_by_controller(substr(strrchr(__CLASS__, '\\'), 1))) {
            return redirect()->to(strtolower(substr(strrchr(__CLASS__, '\\'), 1)) . "/$id");
        }

        $roastcolour = $this->getRoastColourOr404($id);

        return view("RoastColours/delete", [
            "roastcolour" => $roastcolour
        ]);
    }

    public function delete($id)
    {
        try {
            $this->model->delete($id);
        } catch (DatabaseException $e) {
            return redirect()->back()->with("errors", $this->model->errors())->withInput();
        }
        return redirect()->to("RoastColours")->with("message", "Roast Colour deleted.");
    }

    private function getRoastColourOr404($id): RoastColour
    {
        $data = $this->model->find($id);

        if ($data === null) {
            throw new PageNotFoundException("Roast Colour with id $id not found");
        }

        return $data;
    }
}
