<?php

namespace App\Controllers;

use App\Models\ProcessesModel;
use App\Entities\Process;
use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Database\Exceptions\DatabaseException;

class Processes extends BaseController
{
    private ProcessesModel $model;

    public function __construct()
    {
        $this->model = new ProcessesModel;
    }
    
    public function index(): string
    {
        
        $data = $this->model
        ->select(("processes.*, users.username"))
        ->join("users","users.id = processes.users_id","left")
        ->orderBy('Process','asc')->findAll();

        return view("Processes/index",[
                "processes" => $data
            ]);
    }
 
    public function show($id)
    {

        $process = $this->getProcessOr404($id);
        
		$sql = "SELECT inputs.InputID, inputs.InputName FROM inputs WHERE inputs.ProcessID=$id";
		$db = db_connect();
		$inputs = $db->query($sql)->getResult('App\Entities\Input');

        return view("Processes/show",[
            "process" => $process,
            "inputs" => $inputs
        ]);

    }

    public function new()
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1)) );
		}

        return view("Processes/new",[
            "process" => new Process
        ]);
    }

    public function create()
    {

        $process = new Process($this->request->getPost());

        $id = $this->model->insert($process);

        if($id === false){

            return redirect()->back()->with("errors", $this->model->errors())->withInput();

        }

        return redirect()->to("processes/$id")->with("message","Process saved.");

    }

    public function edit($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $process = $this->getProcessOr404($id);

        return view("Processes/edit",[
            "process" => $process
        ]);

    }


    public function update($id)
    {

        $process = $this->getProcessOr404($id);

        $process->fill($this->request->getPost());

        $process->__unset("_method");

        if(!$process->hasChanged()){
            return redirect()->back()->with("message","Nothing to update.");
        }

        if($this->model->save($process)){
            return redirect()->to("processes/$id")->with("message","Process updated");
        }

        return redirect()->back()->with("errors",$this->model->errors())->withInput();
    }

    public function confirmDelete($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $process = $this->getProcessOr404($id);

        return view("Processes/delete",[
            "process"=>$process
        ]);
    }
    public function delete($id)
    {
        try{
            $this->model->delete($id);

        } catch (DatabaseException $e) {
            return redirect()->back()->with("errors",$this->model->errors())->withInput();
        }
        return redirect()->to("processes")->with("message","Process deleted.");

        // $process = $this->getProcessOr404($id);

        // $this->model->delete($id);

        // return redirect()->to("processes")->with("message","Process deleted.");
    }

    private function getProcessOr404($id): Process
    {
        $process = $this->model->find($id);

        if($process === null){
            throw new PageNotFoundException("Process with id $id not found");
        }

        return $process;
    }
}
