<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Shield\Models\UserModel as ModelsUserModel;

class Password extends BaseController
{
    public function set()
    {
        return view("Password/set");
    }

    public function update()
    {
        $rules =[
            "password" => [
                "label" => "Password",
                "rules" => "required|strong_password"
            ],
            "password_confirmation" => [
                "label" => "Password Confirmation",
                "rules" => "required|matches[password]"
            ]
        ];
        if( ! $this->validate($rules)) {
            return redirect()->back()
                            ->with("errors", $this->validator->getErrors());
        }

        $user = auth()->user();

        $user->password = $this->request->getPost("password");

        $model = new UserModel;
        $model->save($user);

        session()->removeTempdata("magicLogin");

        return redirect()->to("/")->with("message", "Password changed successfully");

    }

    public function change()
    {
        return view("Password/change");
    }

    public function changeUpdate()
    {
        $rules =[
            "password" => [
                "label" => "Password",
                "rules" => "required|strong_password"
            ],
            "password_confirmation" => [
                "label" => "Password Confirmation",
                "rules" => "required|matches[password]"
            ]
        ];
        if( ! $this->validate($rules)) {
            return redirect()->back()
                            ->with("errors", $this->validator->getErrors());
        }

        $user = auth()->user();

        $user->password = $this->request->getPost("password");

        $model = new UserModel;
        $model->save($user);

        session()->removeTempdata("magicLogin");

        return redirect()->to("login")->with("message", "Password changed successfully");

    }

    public function reset($id)
    {
        $model = new UserModel;

        $user = $model->findById($id);

        return view("Password/reset",[
            "user" => $user,
        ]);
    }

    public function resetUpdate($id)
    {
        $rules =[
            "password" => [
                "label" => "Password",
                "rules" => "required|strong_password"
            ],
            "password_confirmation" => [
                "label" => "Password Confirmation",
                "rules" => "required|matches[password]"
            ]
        ];

        if( ! $this->validate($rules)) {
            return redirect()->back()
                            ->with("errors", $this->validator->getErrors());
        }

        $model = new UserModel;

        $user = $model->findById($id);
        
        $user->password = $this->request->getPost("password");

        $model = new UserModel;
        $model->save($user);

        session()->removeTempdata("magicLogin");

        return redirect()->to("users")->with("message", "Password for $user->username changed successfully");

    }

}
