<?php

namespace App\Controllers;

use App\Models\InputTypesModel;
use App\Entities\InputType;
use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Database\Exceptions\DatabaseException;

class Inputtypes extends BaseController
{
    private InputTypesModel $model;

    public function __construct()
    {
        $this->model = new InputTypesModel;
    }
    
    public function index(): string
    {
        //$db = db_connect();
        //$db->listTables();
        
        $data = $this->model
        ->select(("inputtypes.*, users.username"))
        ->join("users","users.id = inputtypes.users_id","left")
        ->findAll();

        /*$data = [
            ["title"=>"One", "content"=>"The first"],
            ["title"=>"Two", "content"=>"Some Content"]
        ];*/

        return view("InputTypes/index",[
                "inputtypes" => $data
            ]);
    }
 
    public function show($id)
    {

        $inputtype = $this->getInputTypeOr404($id);

		$sql = "SELECT inputs.InputID, inputs.InputName FROM inputs WHERE inputs.InputTypeID=$id";
		$db = db_connect();
		$inputs = $db->query($sql)->getResult('App\Entities\Input');

        return view("InputTypes/show",[
            "inputtype" => $inputtype,
            "inputs" => $inputs
        ]);

    }

    public function new()
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1)) );
		}

        $inputtype = new InputType;
        $inputtype->IsCoffee = 0;
        return view("InputTypes/new",[
            "inputtype" => $inputtype
        ]);
    }

    public function create()
    {

        $inputtype = new InputType($this->request->getPost());

        //dd($inputtype);
        if($inputtype->IsCoffee === '1'){
            $inputtype->IsCoffee = 1;
        }else{
            $inputtype->IsCoffee = 0;
        }

        $id = $this->model->insert($inputtype);

        if($id === false){

            return redirect()->back()->with("errors", $this->model->errors())->withInput();

        }

        return redirect()->to("inputtypes/$id")->with("message","Input Type saved.");

    }

    public function edit($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $inputtype = $this->getInputTypeOr404($id);

        return view("InputTypes/edit",[
            "inputtype" => $inputtype
        ]);

    }


    public function update($id)
    {

        $inputtype = $this->getInputTypeOr404($id);

        $inputtype->fill($this->request->getPost());

        $inputtype->__unset("_method");

        if(!$inputtype->hasChanged()){
            return redirect()->back()->with("message","Nothing to update.");
        }

        //dd($inputtype);

        if($inputtype->IsCoffee === '1'){
            $inputtype->IsCoffee = 1;
        }else{
            $inputtype->IsCoffee = 0;
        }

        //dd($inputtype);

        if($this->model->save($inputtype)){
            return redirect()->to("inputtypes/$id")->with("message","Input Type updated");
        }

        return redirect()->back()->with("errors",$this->model->errors())->withInput();
    }

    public function confirmDelete($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $inputtype = $this->getInputTypeOr404($id);

        return view("InputTypes/delete",[
            "inputtype"=>$inputtype
        ]);
    }
    public function delete($id)
    {
        try{
            $this->model->delete($id);

        } catch (DatabaseException $e) {
            return redirect()->back()->with("errors",$this->model->errors())->withInput();
        }
        return redirect()->to("inputtypes")->with("message","Input Type deleted.");

        // $inputtype = $this->getInputTypeOr404($id);

        // $this->model->delete($id);

        // return redirect()->to("inputtypes")->with("message","Input Type deleted.");
    }

    private function getInputTypeOr404($id): InputType
    {
        $inputtype = $this->model->find($id);

        if($inputtype === null){
            throw new PageNotFoundException("Input type with id $id not found");
        }

        return $inputtype;
    }
}
