<?php

namespace App\Controllers;

use App\Models\RecipeInputsModel;
use App\Entities\RecipeInput;

use App\Models\InputTypesModel;
use App\Entities\InputType;

use CodeIgniter\Exceptions\PageNotFoundException;

class Coffeedemand extends BaseController
{
    private RecipeInputsModel $model;
    private InputTypesModel $inputtypesmodel;

    public function __construct()
    {
        $this->model = new RecipeInputsModel;
        $this->inputtypesmodel = new InputTypesModel;
    }

    public function index($inputtypeid): string
    {
        $demands = $this->getDemand($inputtypeid);

        $inputtype = $this->getInputTypeOr404($inputtypeid);

        return view("CoffeeDemand/index",[
            "demands" => $demands,
            "inputtypeid" => $inputtypeid,
            "inputtype" => $inputtype,
        ]);
    }

    public function export($inputtypeid): string
    {
        $demands = $this->getDemand($inputtypeid);
        $inputtype = $this->getInputTypeOr404($inputtypeid);

        return view("CoffeeDemand/export",[
            "demands" => $demands,
            "inputtypeid" => $inputtypeid,
            "inputtype" => $inputtype,
        ]);

    }

    private function getInputTypeOr404($inputtypeid)
    {
        $data = $this->inputtypesmodel->find($inputtypeid);
        return $data;
    }

    private function getDemand($inputtypeid) :array
    {
        $coffeedemands =$this-> getDemandOr404($inputtypeid);
        //dd($coffeedemands);
        $coffees = [];
        $totals = [];
        $recipeids = [];
        $inputids = [];
        $iscoffee = false;
        if(count($coffeedemands) > 0) {
            $iscoffee = $coffeedemands[0]->IsCoffee == 0 ? false: true;
        }
        foreach($coffeedemands as $coffeedemand){
            if(array_key_exists($coffeedemand->InputName,$coffees) == false){
                $coffees += [$coffeedemand->InputName => 0];
                $totals += [$coffeedemand->InputName => 0];
                $inputids = [...$inputids, $coffeedemand->InputID];
            }
        }
        $recipes = [];
        foreach($coffeedemands as $coffeedemand){
            // Roots Botanical - 1Kg
            $recipename = $coffeedemand->RecipeName;
            $coffee = $coffeedemand->InputName;
            $recipeid = $coffeedemand->RecipeID;
            $inputid = $coffeedemand->InputID;
            if($iscoffee === true){
                $demand = $coffeedemand->AnnualDemand;
            }else{
                $demand = $coffeedemand->AnnualCount;
            }
            //echo $demand .'<br/>';

            if(array_key_exists($recipename,$recipes) == false){
                // Not Found
                $recipes += [$recipename => $coffees];

                $recipeids = [...$recipeids, $recipeid];

//                $recipes += [$recipename => ["recipeid"=>$recipeid,"inputid"=>$inputid,"coffees"=>$coffees]];
            }
//            $recipes[$recipename]->coffees[$coffee] += $demand; 
            $recipes[$recipename][$coffee] += $demand; 
//dd($recipes);
            $totals[$coffee] += $demand;

            // echo $recipename . '  ' . $coffee . '   ' . $demand .'<br/>';

        }

        $recipes += ['Totals' => $totals];
        $recipes += ['InputIDs' => $inputids];
        $recipes += ['RecipeIDs' => $recipeids];
        //dd($recipes);
        return $recipes;
    }

    private function getDemandOr404($inputtypeid): array
    {

        $coffeedemand = $this->model->query("SELECT  recipeinputs.RecipeID, 
        concat(recipes.RecipeName,' <small>(',FORMAT(recipes.AnnualKg,0),'Kg)</small>') as RecipeName,
 recipeinputs.InputID, 
 case when ifnull(inputtypes.IsCoffee,0)<>0 then inputs.InputName else concat(inputs.InputName,'<br/><small>(',FORMAT(inputs.WastePercent,0),'% wastage)</small>') end as InputName,
 recipeinputs.Qty
,recipes.AnnualKg
,ifnull(inputtypes.IsCoffee,0) AS IsCoffee
,ROUND(
case when t.TotalInput = 0 then 0 ELSE (recipeinputs.Qty / t.TotalInput) * recipes.AnnualKg END 
* (1 + (recipes.WastePercent/100)),2) AS AnnualDemand,
ROUND( 
(ifnull(recipes.AnnualKg / (recipes.PackQty/1000),0) * recipeinputs.Qty) * (1 + (inputs.WastePercent/100)),2)
AS AnnualCount
FROM recipeinputs
LEFT JOIN inputs ON recipeinputs.InputID=inputs.InputID
LEFT JOIN inputtypes ON inputs.InputTypeID=inputtypes.InputTypeID
LEFT JOIN recipes ON recipeinputs.RecipeID=recipes.RecipeID
LEFT JOIN (
SELECT recipeinputs.RecipeID, 
ifnull(SUM(recipeinputs.Qty),0) AS TotalInput
FROM recipeinputs
LEFT JOIN recipes ON recipeinputs.RecipeID=recipes.RecipeID
LEFT JOIN inputs ON recipeinputs.InputID=inputs.InputID
LEFT JOIN inputtypes ON inputs.InputTypeID=inputtypes.InputTypeID
WHERE ifnull(inputtypes.IsCoffee,0)<>0
GROUP BY recipeinputs.RecipeID
) t ON recipeinputs.RecipeID = t.RecipeID
WHERE ifnull(inputtypes.InputTypeID,0)=$inputtypeid
GROUP BY recipeinputs.RecipeID, recipeinputs.InputID
ORDER BY recipes.RecipeName,inputs.InputName")->getResult(\App\Entities\CoffeeDemand::class);

        return $coffeedemand;
    }

    private function getCoffeeDemandOr404($inputtypeid): array
    {

        $coffeedemand = $this->model->query("SELECT  recipeinputs.RecipeID, recipes.RecipeName,
 recipeinputs.InputID, inputs.InputName,
 recipeinputs.Qty
,recipes.AnnualKg
,round(case when t.TotalCoffee = 0 then 0 ELSE (recipeinputs.Qty / t.TotalCoffee) * recipes.AnnualKg END ,2) AS AnnualDemand
--,round(case when t.TotalCoffee = 0 then 0 ELSE (recipeinputs.Qty / t.TotalCoffee) * recipes.AnnualKg END * (1 + (recipes.WastePercent/100)),2) AS AnnualDemand
FROM recipeinputs
LEFT JOIN inputs ON recipeinputs.InputID=inputs.InputID
LEFT JOIN inputtypes ON inputs.InputTypeID=inputtypes.InputTypeID
LEFT JOIN recipes ON recipeinputs.RecipeID=recipes.RecipeID
LEFT JOIN (
SELECT recipeinputs.RecipeID, 
ifnull(SUM(recipeinputs.Qty),0) AS TotalCoffee
FROM recipeinputs
LEFT JOIN recipes ON recipeinputs.RecipeID=recipes.RecipeID
LEFT JOIN inputs ON recipeinputs.InputID=inputs.InputID
LEFT JOIN inputtypes ON inputs.InputTypeID=inputtypes.InputTypeID
WHERE ifnull(inputtypes.IsCoffee,0)<>0
GROUP BY recipeinputs.RecipeID
) t ON recipeinputs.RecipeID = t.RecipeID
WHERE ifnull(inputtypes.InputTypeID,0)=$inputtypeid
GROUP BY recipeinputs.RecipeID, recipeinputs.InputID
ORDER BY recipes.RecipeName,inputs.InputName")->getResult(\App\Entities\CoffeeDemand::class);

        return $coffeedemand;
    }
}
