<?php

namespace App\Controllers;

use App\Models\CertificationsModel;
use App\Entities\Certification;
use App\Entities\Input;
use CodeIgniter\Exceptions\PageNotFoundException;
use CodeIgniter\Database\Exceptions\DatabaseException;

class Certifications extends BaseController
{
    private CertificationsModel $model;

    public function __construct()
    {
        $this->model = new CertificationsModel;
    }
    
    public function index(): string
    {
        
        $data = $this->model
                    ->select(("certifications.*, users.username"))
                    ->join("users","users.id = certifications.users_id","left")
                    ->findAll();

        return view("Certifications/index",[
                "certifications" => $data
            ]);
    }
 
    public function show($id)
    {

        $certification = $this->getCertificationOr404($id);
        
		$sql = "SELECT inputs.InputID, inputs.InputName FROM inputs WHERE inputs.CertificationID=$id";
		$db = db_connect();
		$inputs = $db->query($sql)->getResult('App\Entities\Input');
        
        return view("Certifications/show",[
            "certification" => $certification,
            "inputs" => $inputs,
        ]);

    }

    public function new()
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1)) );
		}

        return view("Certifications/new",[
            "certification" => new Certification
        ]);
    }

    public function create()
    {

        $certification = new Certification($this->request->getPost());
//dd($certification);
        $id = $this->model->insert($certification);

        if($id === false){

            return redirect()->back()->with("errors", $this->model->errors())->withInput();

        }

        return redirect()->to("certifications/$id")->with("message","Certification saved.");

    }

    public function edit($id)
    {

		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

        $certification = $this->getCertificationOr404($id);

        return view("Certifications/edit",[
            "certification" => $certification
        ]);

    }


    public function update($id)
    {

        $certification = $this->getCertificationOr404($id);

        $certification->fill($this->request->getPost());

        $certification->__unset("_method");

        if(!$certification->hasChanged()){
            return redirect()->back()->with("message","Nothing to update.");
        }

        if($this->model->save($certification)){
            return redirect()->to("certifications/$id")->with("message","Certification updated");
        }

        return redirect()->back()->with("errors",$this->model->errors())->withInput();
    }

    public function confirmDelete($id)
    {
		if (! auth()->user()->can_edit_by_controller( substr(strrchr(__CLASS__, '\\'), 1) ) ) {
			return redirect()->to( strtolower(substr(strrchr(__CLASS__, '\\'), 1))."/$id" );
		}

		$certification = $this->getCertificationOr404($id);

        return view("Certifications/delete",[
            "certification"=>$certification
        ]);
    }
    public function delete($id)
    {
        try{
            $this->model->delete($id);

        } catch (DatabaseException $e) {
            return redirect()->back()->with("errors",$this->model->errors())->withInput();
        }
        return redirect()->to("certifications")->with("message","Certification deleted.");

        // $certification = $this->getCertificationOr404($id);

        // $this->model->delete($id);

        // return redirect()->to("certifications")->with("message","Certification deleted.");
    }

    private function getCertificationOr404($id): Certification
    {
        $certification = $this->model->find($id);

        if($certification === null){
            throw new PageNotFoundException("Certification with id $id not found");
        }

        return $certification;
    }
}
